-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
require( "scripts/tittle_style.lua" );


MyFont = {
  standardFont,
  30,
  BlackColor
};

NameFont = {
  standardFont,
  17,
  TittleAqua
};

local playername = gEnterNameValue;
local deleteselected = false;

if not playername or playername=="" then
	deleteselected = true;
	playername = GetString("enternameprompt") ;
end

kButtonY = 260;

MakeDialog
{
	Bitmap
	{
		image="images/ui/common/popup02",
		x=kCenter,
		y=kCenter,
		EnterNameWindow
		{
			x=0,y=20,w=kMax,h=kMax,
			
			Text
			{
				font = PopupFont,
				name = "entername",
				x=0,y=40,w=kMax,h=30,
				flags = kHAlignCenter + kVAlignTop,
				label = "entername"
			};

			Bitmap
			{
				image="images/ui/buttons/box01",
				x=kCenter,
				y=kCenter,

				TextEdit
				{
					font = NameFont,
					name = "nameedit",
					label = playername,
					enablewindow = "enterok",
					clearinitial = deleteselected,
					x=12,y=13,w=kMax-3,h=kMax,
					length=21,
					ignore = kIllegalNameChars

				};
			};
			
			SetStyle(FitnessButtonStyleTittleSmallBlue2),
	--Cancel	
			SBButton
			{
				x=kCenter+64,
				y=kButtonY,
				name="entercancel",
				label="common.cancel.label",
				icon="assets/images/ui/buttons/icon/iconcancel",
				command =
					function()
						CloseWindow(nil);
					end
			};
	--OK
			SBButton
			{			
				x=kCenter-64,
				y=kButtonY,
				h=80,
				name="enterok",
				label="common.ok.label",
				icon="assets/images/ui/buttons/icon/iconok",		
				default = true,

				command =
					function()
						local newname = GetLabel("nameedit");
						if (newname ~= playername and IsNameInUse(newname)) then
							DisplayDialog {
								"scripts/ok.lua",
								body ="nameinuse_2",
								title = "nameinuse"
							};
							SetFocus( "nameedit" )
						else												
							CloseWindow(GetLabel("nameedit"));
						end
					end
			
			},
		},
	
	},

}

SetFocus( "nameedit" );

if (deleteselected) then
	EnableWindow("enterok", false);
end


